-- Oracle drop constraints and indices script

-------------------------
-- drop data table indices
-------------------------

-------------------------
-- uniques (4 indices)
select 'dropping uniques indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table uniques drop constraint uniques_key_PK_IDX;
drop index uniques_signed_IDX;
drop index uniques_code_CK_IDX;
drop index uniques_name_IDX;

select 'finished dropping uniques indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- updates (6 indices, 1 foreign key) -- need to to drop FK before getting to table hundred
select 'dropping updates indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table updates drop constraint updates_key_PK_IDX;
drop index updates_int_IDX;
alter table updates drop constraint updates_int_FK;
drop index updates_signed_IDX;
drop index updates_decim_IDX;
drop index updates_date_IDX;
drop index updates_code_CK_IDX;

select 'finished dropping updates indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- hundred (6 indices)
select 'dropping hundred indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table hundred drop constraint hundred_key_PK_IDX;
drop index hundred_int_IDX;
drop index hundred_signed_IDX;
drop index hundred_date_IDX;
drop index hundred_code_CK_IDX;
drop index hundred_name_IDX;

select 'finished dropping hundred indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- tenpct (9 indices)
select 'dropping tenpct indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table tenpct drop constraint tenpct_key_code_PK_IDX;
drop index tenpct_int_IDX;
drop index tenpct_signed_IDX;
drop index tenpct_float_IDX;
drop index tenpct_double_IDX;
drop index tenpct_decim_IDX;
drop index tenpct_date_IDX;
drop index tenpct_code_CK_IDX;
drop index tenpct_name_IDX;

select 'finished dropping tenpct indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- tenthou (5 indices)
select 'dropping tenthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table tenthou drop constraint tenthou_key_code_PK_IDX;
drop index tenthou_signed_IDX;
drop index tenthou_decim_IDX;
drop index tenthou_code_CK_IDX;
drop index tenthou_name_IDX;

select 'finished dropping tenthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- hunthou (1 index)
select 'dropping hunthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

drop index hunthou_signed_IDX;

select 'finished dropping hunthou indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- twomill (3 indices)
select 'dropping twomill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table twomill drop constraint twomill_key_PK_IDX;
drop index twomill_date_IDX;
drop index twomill_code_CK_IDX;

select 'finished dropping twomill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- threemill (2 indices)
select 'dropping threemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table threemill drop constraint threemill_key_PK_IDX;
drop index threemill_signed_IDX;

select 'finished dropping threemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- fourmill (2 indices)
select 'dropping fourmill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table fourmill drop constraint fourmill_key_PK_IDX;
drop index fourmill_name_IDX;

select 'finished dropping fourmill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- fivemill (2 indices)
select 'dropping fivemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table fivemill drop constraint fivemill_key_PK_IDX;
drop index fivemill_code_CK_IDX;

select 'finished dropping fivemill indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- fourram (1 index)
select 'dropping fourram indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table fourram drop constraint fourram_key_PK_IDX;

select 'finished dropping fourram indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- create housekeeping table indices
-------------------------

-- update_int_history (2 indices)
select 'dropping update_int_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table update_int_history drop constraint up_int_hist_key_int_PK_IDX;
drop index update_int_history_int_IDX;

select 'finished dropping update_int_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-- update_signed_history (2 indices)
select 'dropping update_signed_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table update_signed_history drop constraint up_sign_hist_key_sign_PK_IDX;
drop index up_sign_hist_sign_IDX;

select 'finished dropping update_signed_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-- del_history (1 index)
select 'dropping del_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

alter table del_history drop constraint del_history_key_PK_IDX;

select 'finished dropping del_history indices' as message, to_char(sysdate,'MM-DD-YYYY HH24:MI:SS') as time from dual;

-------------------------
-- end
-------------------------

commit;
exit
